package objectos_casa;

import javax.imageio.ImageIO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/**
 * Created by Pedro on 06/04/2016.
 */
public class Def_func extends ObjectoCasa {
    public String nome;
    public ArrayList <ObjectoCasa> parametros;

    public Def_func(int numero_id, String identificador, ArrayList<ObjectoCasa> args_funcao){
        path_icone = "def_func.bmp";
        id=numero_id;
        nome=identificador;
        parametros =args_funcao;
    }

    public Def_func(int numero_id, String identificador){
        path_icone = "def_func.bmp";
        id=numero_id;
        nome=identificador;
        parametros =new ArrayList<>();
    }

    public void setNome(String n){
        nome=n;
    }

    public void addParametro(ObjectoCasa o){
        parametros.add(o);
    }

    public void removeParametro (int pos){
        parametros.remove(pos);
    }

    public Boolean setNomeParametro(int index, String novoNome){
        if(index<0||index>parametros.size()) {
            System.err.println("Index fora dos limites da lista de argumentos!");
            return false;
        }
        ObjectoCasa o=parametros.get(index);

        switch (o.tipo_objecto()){
            case "int":
                ((Int_casa) o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "string":
                ((String_casa)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "double":
                ((Double_casa)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "char":
                ((Char_casa)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "boolean":
                ((Boolean_casa)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "array_int":
                ((Array_int)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "array_double":
                ((Array_double)o).nome=novoNome;
                parametros.set(index,o);
                return true;
            case "array_string":
                ((Array_string)o).nome=novoNome;
                parametros.set(index,o);
                return true;
        }

        return false;
    }

    public String parametrosToString(){
        String param="";
        int pos=0;
        for(ObjectoCasa obj:parametros) {
            pos++;
            param += "\n|Param. Nº"+pos+" - nome: " + obj.to_expressao() + "  tipo: " + obj.tipo_objecto() + "|";
        }

        return param;
    }

    public String gerar(){
        ArrayList<String> par= new ArrayList<>();
        for(ObjectoCasa obj:parametros)
            par.add(obj.to_expressao());
        return "def "+nome+par.toString().replace('[','(').replace(']',')')+":\n";
    }

    @Override
    public String tipo_objecto(){return "def_func";}

    public String to_expressao() {
        return null;
    }


}
